/* Replace DataBase with correct value */
USE [DataBase]
GO

/****** Object:  Trigger [SchemaName].[tr_TableName_update]    Script Date: 04/11/2014 17:02:04 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

/* Replace SchemaName and TableName with correct values */
CREATE TRIGGER [SchemaName].[tr_TableName_update]
   ON  [SchemaName].[TableName]
   AFTER UPDATE
AS 
BEGIN
    SET NOCOUNT ON;
	
	DECLARE @changed TABLE
		( OID int )		/* Replace OID with unique key field from table */
  
	INSERT INTO @changed (OID)	/* Replace OID with unique key field from table */
		SELECT DELETED.OID		/* Replace OID with unique key field from table */
		FROM DELETED
		INNER JOIN INSERTED ON DELETED.OID = INSERTED.OID  
		WHERE DELETED.[geom].STEquals(INSERTED.[geom])=0	/* Replace geom with geometry field from table */				
		OR DELETED.[Field1] != INSERTED.[Field1]
		OR DELETED.[Fieldn] != INSERTED.[Fieldn]	/* Replace Field1 to Fieldn with attribute fields from table */
		OR DELETED.[asq_lasteditedby] != INSERTED.[asq_lasteditedby]
		OR DELETED.[asq_lasteditedwhen] != INSERTED.[asq_lasteditedwhen]
    
	/* Replace SchemaName and TableName with correct values */
	INSERT INTO [SchemaName_archive].[TableName]
		([OldOID]	
		,[archive_action]
		,[archive_user]
		,[archive_datetime]
		,[geom]		/* Replace geom with geometry field from table */
        ,[Field1]
        ,[Fieldn]	/* Replace Field1 to Fieldn with attribute fields from table */
		,[asq_lasteditedby]
		,[asq_lasteditedwhen]
		,[asq_lockedby])
	 SELECT DELETED.OID		/* Replace OID with unique key field from table */
		,'Update'
		,SYSTEM_USER
		,CURRENT_TIMESTAMP
		,[geom]		/* Replace geom with geometry field from table */
		,[Field1]
        ,[Fieldn]	/* Replace from [Field1] to [Fieldn] with attribute fields from table */
		,[asq_lasteditedby]
		,[asq_lasteditedwhen]
		,[asq_lockedby]
	  FROM DELETED
	  INNER JOIN @changed as CHANGED on CHANGED.OID = DELETED.OID  /* Replace OID with unique key field from table */
END

GO


